/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.Iterator;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.level.BlockEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class BenthamismModifier
extends Modifier
implements ProcessLootModifierHook {
    private static final TinkerDataCapability.TinkerDataKey<Integer> BENTHAMISM = TConstruct.createKey((String)"benthamism");

    public BenthamismModifier() {
        MinecraftForge.EVENT_BUS.addListener(this::onExperienceDrop);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityKilled);
        MinecraftForge.EVENT_BUS.addListener(this::beforeBlockBreak);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.PROCESS_LOOT);
    }

    private static int boost(int original, int level) {
        float modifier = 1.0f + RANDOM.nextFloat() * (float)level;
        return (int)((float)original * modifier);
    }

    private void beforeBlockBreak(BlockEvent.BreakEvent event) {
        int level = 0;
        ToolStack tool = BenthamismModifier.getHeldTool((LivingEntity)event.getPlayer(), (InteractionHand)InteractionHand.MAIN_HAND);
        if (tool != null) {
            level = tool.getModifierLevel((Modifier)this);
        }
        if ((tool = BenthamismModifier.getHeldTool((LivingEntity)event.getPlayer(), (EquipmentSlot)EquipmentSlot.LEGS)) != null) {
            level += tool.getModifierLevel((Modifier)this);
        }
        if (level > 0) {
            event.setExpToDrop(BenthamismModifier.boost(event.getExpToDrop(), level));
        }
    }

    private void onEntityKilled(LivingDeathEvent event) {
        Projectile projectile;
        ModifierNBT modifiers;
        Entity entity;
        DamageSource source = event.getSource();
        if (source != null && (entity = source.m_7640_()) instanceof Projectile && !(modifiers = EntityModifierCapability.getOrEmpty((Entity)(projectile = (Projectile)entity))).isEmpty()) {
            event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(BENTHAMISM, (Object)modifiers.getLevel(this.getId())));
        }
    }

    private void onExperienceDrop(LivingExperienceDropEvent event) {
        Player player;
        int benthamism = event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> (Integer)data.get(BENTHAMISM)).orElse(-1);
        if (benthamism > 0) {
            event.setDroppedExperience(BenthamismModifier.boost(event.getDroppedExperience(), benthamism));
        } else if (benthamism != 0 && (player = event.getAttackingPlayer()) != null) {
            int level = 0;
            ToolStack tool = BenthamismModifier.getHeldTool((LivingEntity)player, (EquipmentSlot)ModifierLootingHandler.getLootingSlot((LivingEntity)player));
            if (tool != null) {
                level = tool.getModifierLevel((Modifier)this);
            }
            if (level > 0) {
                event.setDroppedExperience(BenthamismModifier.boost(event.getDroppedExperience(), level));
            }
        }
    }

    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        Iterator<ItemStack> iterator = generatedLoot.iterator();
        int level = modifier.getLevel();
        while (iterator.hasNext()) {
            if (!(RANDOM.nextFloat() <= 0.2f * (float)level)) continue;
            ItemStack stack = iterator.next();
            stack.m_41720_();
            iterator.remove();
        }
    }
}

